package com.payfort.sdk.android.dependancies.connection;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;

import javax.net.ssl.HttpsURLConnection;

/**
 * Created by gbarham on 2/8/2016.
 */
public class ConnectionAdapter {

	public static final String ENVIRONMENT_SANDBOX = "https://sbcheckout.payfort.com";
	public static final String ENVIRONMENT_PRODUCTION = "https://checkout.payfort.com";

	/**
	 * @param context
	 * @param environment
	 * @param URI
	 * @return
	 * @throws Exception
	 */
	public HttpsURLConnection setupConnection(String environment, String URI) throws Exception {
		TLSSocketFactory tlsSocketFactory = null;
		URL url = new URL(environment + URI);
		tlsSocketFactory = new TLSSocketFactory();

		HttpsURLConnection urlConnection = (HttpsURLConnection) url.openConnection();
		urlConnection.setSSLSocketFactory(tlsSocketFactory);
		// post/json request
		urlConnection.setDoOutput(true);
		urlConnection.setConnectTimeout(30000); // set timeout to 5 seconds
		urlConnection.setRequestProperty("Content-Type", "application/json");
		urlConnection.setRequestProperty("Accept", "application/json");
		urlConnection.setRequestMethod("POST");
		urlConnection.setRequestProperty("charset", "utf-8");
		urlConnection.setUseCaches(false);
		return urlConnection;
	}
	
	
	public String exchangeData(HttpsURLConnection urlConnection, String encryptedData)throws Exception{
        OutputStreamWriter out = new OutputStreamWriter(urlConnection.getOutputStream());
        out.write(encryptedData);
        out.close();

        StringBuilder sb = new StringBuilder();
        int HttpResult = urlConnection.getResponseCode();
        if (HttpResult == HttpURLConnection.HTTP_OK) {
            BufferedReader br = new BufferedReader(new InputStreamReader(
                    urlConnection.getInputStream(), "utf-8"));
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            br.close();
        }
        urlConnection.disconnect();
        return "" + sb.toString();
    }
}
