package com.payfort.sdk.android.dependancies.utils;

import java.util.regex.Pattern;

import com.payfort.sdk.android.dependancies.commons.Constants;

/**
 * Created by gbarham on 12/9/2015.
 */
public class Validate {

	/**
	 * @param arg
	 * @param name
	 */
	public static void notNull(Object arg, String name) {
		if (arg == null) {
			throw new NullPointerException("Argument '" + name + "' cannot be null");
		}
	}

	/**
	 * @param number
	 * @return
	 */
	public static boolean luhnValidation(String number) {
		int s1 = 0, s2 = 0;
		String reverse = new StringBuffer(number).reverse().toString();
		for (int i = 0; i < reverse.length(); i++) {
			int digit = Character.digit(reverse.charAt(i), 10);
			if (i % 2 == 0) {// this is for odd digits, they are 1-indexed in
				// the algorithm
				s1 += digit;
			} else {// add 2 * digit for 0-4, add 2 * digit - 9 for 5-9
				s2 += 2 * digit;
				if (digit >= 5) {
					s2 -= 9;
				}
			}
		}

		if ((s1 + s2) % 10 == 0) {
			return true;
		}

		return false;
	}

	/**
	 * @param cardBin
	 * @return
	 */
	public static String getPaymentMethodOptionName(String cardBin) {
		try {
			Pattern VISA_PATTERN = Pattern.compile("^4");
			Pattern VISA_ELECTRON_PATTERN = Pattern.compile("^4(026|17500|405|508|844|91[37])");
			Pattern MASTERCARD_PATTERN = Pattern.compile("^(?:5[1-5][0-9]{2}|222[1-9]|22[3-9][0-9]|2[3-6][0-9]{2}|27[01][0-9]|2720)");
			Pattern AMEX_PATTERN = Pattern.compile("^3[47]");
			Pattern MEEZA_PATTERN_1 = Pattern.compile("^6(?:2(?:7(?:59[07]|632|382)|(?:805|766)9|2009|7(?:88|77)8)|0(?:3(?:6(?:65|06)|3(?:53|36)|370)|2(?:85[05]|050)|3794|3(?:73|34|01)8|1(?:844|52[06]|467|368)))[0-9]{10,13}");
			Pattern MEEZA_PATTERN_2 = Pattern.compile("^9818");
			Pattern MAESTRO = Pattern.compile("^(5[06-8]|6\\d)\\d{14}(\\d{2,3})?$");
			
			if (cardBin == null) {
				return null;
			}

			if (VISA_PATTERN.matcher(cardBin).find()) {
				return Constants.CREDIT_CARDS_TYPES.VISA;
			} else if (VISA_ELECTRON_PATTERN.matcher(cardBin).find()) {
				return Constants.CREDIT_CARDS_TYPES.VISA;
			} else if (MASTERCARD_PATTERN.matcher(cardBin).find()) {
				return Constants.CREDIT_CARDS_TYPES.MASTERCARD;
			} else if (AMEX_PATTERN.matcher(cardBin).find()) {
				return Constants.CREDIT_CARDS_TYPES.AMEX;
			} else if (MEEZA_PATTERN_1.matcher(cardBin).find() || MEEZA_PATTERN_2.matcher(cardBin).find()) {
				return Constants.CREDIT_CARDS_TYPES.MEEZA;
			}else if (MAESTRO.matcher(cardBin).find()) {
				return Constants.CREDIT_CARDS_TYPES.MAESTRO;
			}
		} catch (Exception e) {
		}
		return null;
	}
}
